/*
 * Decompiled with CFR 0.152.
 */
package models;

import Manager.PluginConfigurationManagerSingleton;
import httpUtils.HttpClient;
import httpUtils.HttpResponse;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.StringUtils;

public class WebhookSender {
    private static final Logger logger = LoggerFactory.getLogger(WebhookSender.class);
    private static final String CONTENT_TYPE = "content-type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String BITBUCKET_EVENT_HEADER = "X-Event-Key";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private String url;

    public WebhookSender(String url) {
        this.url = url;
    }

    public boolean sendWebhookUpdate(String jsonBody, String bitbucketEvent) {
        if (StringUtils.isNotBlank(bitbucketEvent)) {
            logger.info("Mend plugin: event - " + bitbucketEvent);
        }
        if (StringUtils.isNotBlank(jsonBody)) {
            logger.info("Mend plugin: the request body is: " + jsonBody);
        }
        boolean sendSuccessfully = true;
        HttpClient httpClient = new HttpClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        headers.put(BITBUCKET_EVENT_HEADER, bitbucketEvent);
        headers.put(AUTHORIZATION_HEADER, "Bearer " + PluginConfigurationManagerSingleton.getInstance().getPersonalAccessTokenKey());
        try {
            HttpResponse httpResponse = httpClient.sendPostRequest(this.url, headers, -1, -1, null, jsonBody);
            if (httpResponse.getErrorBody() != null || !"200".equals(httpResponse.getResponseCode())) {
                sendSuccessfully = false;
                Object errorMessage = "";
                if (httpResponse.getErrorBody() != null) {
                    errorMessage = httpResponse.getErrorBody();
                }
                if (StringUtils.isNotBlank(httpResponse.getResponseCode())) {
                    errorMessage = (String)errorMessage + ". Response code: " + httpResponse.getResponseCode();
                }
                logger.error("Failed to update Mend about the webhook " + (String)errorMessage + " with event: " + bitbucketEvent + ", and url: " + this.url + ", and request body: " + jsonBody);
            }
        }
        catch (IOException e) {
            sendSuccessfully = false;
            logger.error("Failed to update Mend about the webhook: " + e.getMessage() + " with event: " + bitbucketEvent + ", and url: " + this.url + ", and request body: " + jsonBody);
        }
        return sendSuccessfully;
    }
}

