/*
 * Decompiled with CFR 0.152.
 */
package httpUtils;

import httpUtils.HttpResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.StringUtils;

public class HttpClient {
    private static final String UTF_8 = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);

    public HttpResponse sendGetRequest(String url, Map<String, String> params, Map<String, String> headers, int conTimeout, int readTimeout, Boolean autoRedirect) throws IOException {
        HttpURLConnection con = this.prepareConnection(url, headers, conTimeout, readTimeout, autoRedirect);
        con.setRequestMethod("GET");
        if (params != null) {
            con.setDoOutput(true);
            String paramsString = this.getParamsString(params);
            OutputStream outputStream = con.getOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeBytes(paramsString);
            out.flush();
            out.close();
        }
        String responseCode = Integer.toString(con.getResponseCode());
        String responseBody = null;
        String errorBody = null;
        if (responseCode.startsWith("2")) {
            responseBody = this.readResponse(con.getInputStream());
        } else {
            errorBody = this.readResponse(con.getErrorStream());
        }
        HttpResponse httpResponse = new HttpResponse(responseCode, responseBody);
        httpResponse.setErrorBody(errorBody);
        String nextPageHeader = con.getHeaderField("Link");
        if (StringUtils.isNotBlank(nextPageHeader)) {
            httpResponse.setLinkHeader(nextPageHeader);
        }
        con.disconnect();
        return httpResponse;
    }

    public HttpResponse sendPostRequest(String url, Map<String, String> headers, int conTimeout, int readTimeout, Boolean autoRedirect, String body) throws IOException {
        HttpURLConnection con = this.prepareConnection(url, headers, conTimeout, readTimeout, autoRedirect);
        con.setRequestMethod("POST");
        con = this.writeToConnection(con, body);
        String responseCode = Integer.toString(con.getResponseCode());
        String responseBody = null;
        String errorBody = null;
        if (responseCode.startsWith("2")) {
            try {
                responseBody = this.readResponse(con.getInputStream());
            }
            catch (IOException e) {
                logger.error("failed to read response body. url: " + url, (Throwable)e);
            }
        } else if (responseCode.startsWith("4")) {
            errorBody = this.readResponse(con.getErrorStream());
        }
        con.disconnect();
        HttpResponse httpResponse = new HttpResponse(responseCode, responseBody);
        httpResponse.setErrorBody(errorBody);
        return httpResponse;
    }

    public HttpResponse sendPatchRequest(String url, Map<String, String> headers, int conTimeout, int readTimeout, Boolean autoRedirect, String body) throws IOException {
        HttpURLConnection con = this.prepareConnection(url, headers, conTimeout, readTimeout, autoRedirect);
        con.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        con.setRequestMethod("POST");
        con = this.writeToConnection(con, body);
        String responseCode = Integer.toString(con.getResponseCode());
        String responseBody = null;
        String errorBody = null;
        if (responseCode.startsWith("2")) {
            try {
                responseBody = this.readResponse(con.getInputStream());
            }
            catch (IOException e) {
                logger.error("failed to read response body. url: " + url, (Throwable)e);
            }
        } else if (responseCode.startsWith("4")) {
            errorBody = this.readResponse(con.getErrorStream());
        }
        con.disconnect();
        HttpResponse httpResponse = new HttpResponse(responseCode, responseBody);
        httpResponse.setErrorBody(errorBody);
        return httpResponse;
    }

    public HttpResponse sendPutRequest(String url, Map<String, String> headers, int conTimeout, int readTimeout, Boolean autoRedirect, String body) throws IOException {
        HttpURLConnection con = this.prepareConnection(url, headers, conTimeout, readTimeout, autoRedirect);
        con.setRequestMethod("PUT");
        con = this.writeToConnection(con, body);
        String responseCode = Integer.toString(con.getResponseCode());
        String responseBody = null;
        String errorBody = null;
        if (responseCode.startsWith("2")) {
            try {
                responseBody = this.readResponse(con.getInputStream());
            }
            catch (IOException e) {
                logger.error("failed to read response body. url: " + url, (Throwable)e);
            }
        } else if (responseCode.startsWith("4")) {
            errorBody = this.readResponse(con.getErrorStream());
        }
        con.disconnect();
        HttpResponse httpResponse = new HttpResponse(responseCode, responseBody);
        httpResponse.setErrorBody(errorBody);
        return httpResponse;
    }

    public HttpResponse sendDeleteRequest(String url, Map<String, String> headers, int conTimeout, int readTimeout, Boolean autoRedirect) throws IOException {
        HttpURLConnection con = this.prepareConnection(url, headers, conTimeout, readTimeout, autoRedirect);
        con.setRequestMethod("DELETE");
        con.connect();
        int intResponseCode = con.getResponseCode();
        String responseCode = null;
        if (intResponseCode > 0) {
            responseCode = Integer.toString(intResponseCode);
        }
        return new HttpResponse(responseCode, null);
    }

    private HttpURLConnection prepareConnection(String url, Map<String, String> headers, int conTimeout, int readTimeout, Boolean autoRedirect) throws IOException {
        URL destinationUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)destinationUrl.openConnection();
        if (autoRedirect != null) {
            connection.setInstanceFollowRedirects(autoRedirect);
        }
        if (conTimeout > 0) {
            connection.setConnectTimeout(conTimeout);
        }
        if (readTimeout > 0) {
            connection.setReadTimeout(readTimeout);
        }
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                connection.setRequestProperty(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        return connection;
    }

    private String readResponse(InputStream inputStream) throws IOException {
        StringBuffer content = new StringBuffer();
        if (inputStream != null) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
                content.append("\n");
            }
            in.close();
        }
        return content.toString();
    }

    private String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), UTF_8));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), UTF_8));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    private HttpURLConnection writeToConnection(HttpURLConnection con, String body) throws IOException {
        con.setDoOutput(true);
        OutputStream out = con.getOutputStream();
        if (body != null) {
            out.write(body.getBytes(UTF_8));
        }
        out.flush();
        out.close();
        return con;
    }
}

