/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.RepositoryServiceManager;
import activeObject.RepoVulInfo;
import activeObject.RepoVulInfoService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.util.HashMap;
import java.util.Map;
import models.RepoSeverityCounter;
import models.SeverityType;

public class VulnerabilitiesPanelContextProvider
implements ContextProvider {
    private final RepoVulInfoService repoVulInfoService;

    public VulnerabilitiesPanelContextProvider(RepoVulInfoService repoVulInfoService) {
        this.repoVulInfoService = repoVulInfoService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Repository repository = (Repository)context.get("repository");
        RepoSeverityCounter repoSeverityCounter = this.getRepoSeverityCounter(RepositoryServiceManager.getFullRepoName(repository));
        HashMap<String, Object> dynamicContext = new HashMap<String, Object>();
        dynamicContext.put("criticalCount", repoSeverityCounter.getNumCritical());
        dynamicContext.put("highCount", repoSeverityCounter.getNumHigh());
        dynamicContext.put("mediumCount", repoSeverityCounter.getNumMedium());
        dynamicContext.put("lowCount", repoSeverityCounter.getNumLow());
        return dynamicContext;
    }

    private RepoSeverityCounter getRepoSeverityCounter(String fullRepoName) {
        RepoSeverityCounter result = new RepoSeverityCounter();
        RepoVulInfo[] allRepoVulInfo = this.repoVulInfoService.findByRepoName(fullRepoName);
        int numLow = 0;
        int numMedium = 0;
        int numHigh = 0;
        int numCritical = 0;
        if (allRepoVulInfo != null) {
            block6: for (RepoVulInfo repoVulInfo : allRepoVulInfo) {
                SeverityType severityType = SeverityType.valueOf(repoVulInfo.getSeverity());
                switch (severityType) {
                    case LOW: {
                        ++numLow;
                        continue block6;
                    }
                    case MEDIUM: {
                        ++numMedium;
                        continue block6;
                    }
                    case HIGH: {
                        ++numHigh;
                        continue block6;
                    }
                    case CRITICAL: {
                        ++numCritical;
                    }
                }
            }
        }
        result.setNumLow(numLow);
        result.setNumMedium(numMedium);
        result.setNumHigh(numHigh);
        result.setNumCritical(numCritical);
        return result;
    }
}

