/*
 * Decompiled with CFR 0.152.
 */
package activeObject;

import activeObject.CommitSummaryBuild;
import activeObject.CommitSummaryService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Named
public class CommitSummaryServiceImpl
implements CommitSummaryService {
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public CommitSummaryServiceImpl(ActiveObjects activeObjects) {
        if (activeObjects == null) {
            throw new NullPointerException();
        }
        this.activeObjects = activeObjects;
    }

    @Override
    public CommitSummaryBuild add(String commit, String summaryHtml) {
        CommitSummaryBuild result;
        CommitSummaryBuild foundSummary = this.findByRepoCommit(commit);
        if (foundSummary == null) {
            result = (CommitSummaryBuild)this.activeObjects.create(CommitSummaryBuild.class, new DBParam[0]);
            result.setCommit(commit);
            result.setSummaryHtml(summaryHtml);
            result.save();
        } else {
            result = foundSummary;
            result.setSummaryHtml(summaryHtml);
            result.save();
        }
        return result;
    }

    @Override
    public CommitSummaryBuild findByRepoCommit(String commit) {
        CommitSummaryBuild[] commitSummaryBuilds;
        CommitSummaryBuild result = null;
        try {
            commitSummaryBuilds = (CommitSummaryBuild[])this.activeObjects.find(CommitSummaryBuild.class, Query.select().where("COMMIT LIKE ?", new Object[]{commit}));
        }
        catch (Exception e) {
            commitSummaryBuilds = (CommitSummaryBuild[])this.activeObjects.find(CommitSummaryBuild.class, Query.select().where("to_char(COMMIT) LIKE ?", new Object[]{commit}));
        }
        if (commitSummaryBuilds != null && commitSummaryBuilds.length > 0) {
            result = commitSummaryBuilds[0];
        }
        return result;
    }
}

