/*
 * Decompiled with CFR 0.152.
 */
package Manager;

import Manager.PluginConfigurationManager;
import Manager.PluginConfigurationManagerSingleton;
import Manager.RepositoryServiceManager;
import Manager.SecurityServiceManager;
import activeObject.IntegratedProject;
import activeObject.IntegratedProjectService;
import activeObject.IntegratedProjectServiceImpl;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.UncheckedOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import models.ExtendedProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectServiceManager {
    private static final Logger logger = LoggerFactory.getLogger(ProjectServiceManager.class);
    private static ProjectService projectService;
    private static IntegratedProjectService integratedProjectService;
    private static final PluginConfigurationManager pluginConfigurationManager;
    private static boolean isMigrationRunning;
    private static String migrationStatusMessage;
    private static final Object lock;

    public static boolean isWhiteSourceIntegrationEnabled(Project project) {
        IntegratedProject integratedProject = integratedProjectService.get(project.getId());
        return integratedProject != null;
    }

    public static void addIntegratedProject(int projectId, boolean includeAllRepositories) {
        integratedProjectService.add(projectId, includeAllRepositories);
    }

    public static void updateIncludeAllReposIndication(int projectId, boolean includeAllRepositories) {
        integratedProjectService.updateAllReposIncluded(projectId, includeAllRepositories);
    }

    public static void removeIntegratedProject(int projectId) {
        integratedProjectService.delete(projectId);
    }

    public static ExtendedProject getProjectFromPath(String[] components) {
        ExtendedProject extendedProject = components == null || components.length < 2 ? null : ProjectServiceManager.getProjectByKey(components[1]);
        return extendedProject;
    }

    public static ExtendedProject getExtendedProject(Project project) {
        ExtendedProject extendedProject = new ExtendedProject(project);
        IntegratedProject integratedProject = integratedProjectService.get(project.getId());
        extendedProject.setIntegratedProject(integratedProject);
        return extendedProject;
    }

    public static ExtendedProject getProjectByKey(final String projectKey) {
        Project project = (Project)SecurityServiceManager.getSecurityService().withPermission(Permission.PROJECT_ADMIN, "Find Project from path").call((Operation)new UncheckedOperation<Project>(){

            public Project perform() {
                return projectService.getByKey(projectKey);
            }
        });
        return ProjectServiceManager.getExtendedProject(project);
    }

    public static List<ExtendedProject> getAllProjects() {
        return ProjectServiceManager.getProjects(false);
    }

    public static List<ExtendedProject> getIntegratedProjects() {
        return ProjectServiceManager.getProjects(true);
    }

    public static boolean isMigrationRunning() {
        return isMigrationRunning;
    }

    public static String getMigrationStatusMessage() {
        return migrationStatusMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateToProjectBasedIntegration() {
        if (isMigrationRunning) {
            return;
        }
        if (pluginConfigurationManager.hasMigrationRan().booleanValue()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (!isMigrationRunning && !pluginConfigurationManager.hasMigrationRan().booleanValue()) {
                logger.info("Started migration...");
                isMigrationRunning = true;
                try {
                    int totalProjectsCounter = 0;
                    int migratedProjectsCounter = 0;
                    boolean isAllRepositories = pluginConfigurationManager.isAllRepositories();
                    pluginConfigurationManager.setAllProjects(isAllRepositories);
                    boolean isLastPage = false;
                    PageRequestImpl pageRequest = new PageRequestImpl(0, 1000);
                    while (!isLastPage) {
                        Page projectPage = projectService.findAll((PageRequest)pageRequest);
                        isLastPage = projectPage.getIsLastPage();
                        pageRequest = projectPage.getNextPageRequest();
                        for (Project project : projectPage.getValues()) {
                            ++totalProjectsCounter;
                            int projectId = project.getId();
                            if (isAllRepositories) {
                                integratedProjectService.add(projectId, true);
                                ++migratedProjectsCounter;
                            } else {
                                boolean doesProjectHasIntegratedRepos = RepositoryServiceManager.doesProjectHaveIntegratedRepos(projectId);
                                if (doesProjectHasIntegratedRepos) {
                                    integratedProjectService.add(projectId, false);
                                    ++migratedProjectsCounter;
                                }
                            }
                            migrationStatusMessage = "Migrated " + migratedProjectsCounter + " projects. Checked " + totalProjectsCounter + " projects.";
                        }
                    }
                    pluginConfigurationManager.setMigrationRan(true);
                    logger.info("Finished migration. isAllRepositories: " + isAllRepositories + ", totalProjects: " + totalProjectsCounter + ", migratedProjects = " + migratedProjectsCounter);
                }
                catch (Exception ex) {
                    logger.error("Migration failed!", (Throwable)ex);
                }
                isMigrationRunning = false;
            }
        }
    }

    public void setProjectService(ProjectService projectService) {
        ProjectServiceManager.projectService = projectService;
    }

    public ProjectService getProjectService() {
        return projectService;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        integratedProjectService = new IntegratedProjectServiceImpl(activeObjects);
    }

    private static List<ExtendedProject> getProjects(boolean onlyIncludeIntegratedProjects) {
        ArrayList<ExtendedProject> extendedProjects = new ArrayList<ExtendedProject>();
        Map<Integer, IntegratedProject> integratedProjectsMap = integratedProjectService.getAll();
        boolean isLastPage = false;
        PageRequestImpl pageRequest = new PageRequestImpl(0, 1000);
        while (!isLastPage) {
            Page projectPage = projectService.findAll((PageRequest)pageRequest);
            isLastPage = projectPage.getIsLastPage();
            pageRequest = projectPage.getNextPageRequest();
            for (Project project : projectPage.getValues()) {
                ExtendedProject extendedProject = new ExtendedProject(project);
                if (integratedProjectsMap.containsKey(project.getId())) {
                    extendedProject.setIntegratedProject(integratedProjectsMap.get(project.getId()));
                    extendedProjects.add(extendedProject);
                    continue;
                }
                if (onlyIncludeIntegratedProjects) continue;
                extendedProjects.add(extendedProject);
            }
        }
        return extendedProjects;
    }

    static {
        pluginConfigurationManager = PluginConfigurationManagerSingleton.getInstance();
        isMigrationRunning = false;
        migrationStatusMessage = "";
        lock = new Object();
    }
}

