/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.BranchServiceManager;
import Manager.PluginConfigurationManager;
import Manager.PluginConfigurationManagerSingleton;
import Manager.ProjectServiceManager;
import Manager.RepositoryHookServiceManager;
import Manager.RepositoryServiceManager;
import activeObject.RepoVulInfo;
import activeObject.RepoVulInfoService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.whitesource.bitbucket.plugin.AbstractServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import models.ExtendedProject;
import models.ExtendedRepository;
import models.RepoVulnerabilityObject;
import models.SeverityType;
import models.WebhookSender;
import org.json.JSONObject;
import utils.ConvertUtils;
import utils.StringUtils;

public class RepositoryServlet
extends AbstractServlet {
    private static final String REPO_ISSUE_WEBHOOK = "issue:created";
    private static final String EVENT_KEY = "eventKey";
    private static final String ACTOR = "actor";
    private static final String REPOSITORY = "repository";
    private static final String ISSUE = "issue";
    public static final String REQUEST_TYPE = "requestType";
    private final RepoVulInfoService repoVulInfoService;
    private final PluginConfigurationManager pluginConfigurationManager;
    private final AuthenticationContext authenticationContext;

    @Inject
    public RepositoryServlet(SoyTemplateRenderer soyTemplateRenderer, RepoVulInfoService repoVulInfoService, AuthenticationContext authenticationContext) {
        super(soyTemplateRenderer);
        this.repoVulInfoService = repoVulInfoService;
        this.pluginConfigurationManager = PluginConfigurationManagerSingleton.getInstance();
        this.authenticationContext = authenticationContext;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (authenticatedRequest) {
            Repository repository = RepositoryServiceManager.getRepoFromPath(request.getPathInfo());
            if (repository == null) {
                response.sendError(404);
                return;
            }
            this.renderIssuesPage(response, repository);
        } else {
            response.setStatus(401);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (authenticatedRequest) {
            String[] requestPathParts = request.getPathInfo().split("/");
            Repository repository = RepositoryServiceManager.getRepoFromPath(requestPathParts);
            String fullRepoName = RepositoryServiceManager.getFullRepoName(repository);
            String requestBody = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            String requestType = this.getRequestType(requestBody, requestPathParts);
            if ("createIssue".equals(requestType)) {
                this.handleCreateIssue(response, repository, fullRepoName, requestBody);
            } else if ("getIssues".equals(requestType)) {
                this.handleGetIssues(response, fullRepoName, repository);
            } else if ("getIssuesById".equals(requestType)) {
                this.handleGetIssueByRepoNameAndId(response, fullRepoName, requestBody);
            } else if ("deleteIssues".equals(requestType)) {
                this.handleDeleteIssues(response, fullRepoName);
            } else if ("updateIssueToEnableRemediate".equals(requestType)) {
                this.handleUpdateIssueToEnableRemediate(repository, response, requestPathParts[requestPathParts.length - 1], request.getRequestURI().split("/updateIssueToEnableRemediate")[0]);
            } else if ("deleteSelectedIssues".equals(requestType)) {
                this.handleDeleteSelectedIssues(repository, response, requestPathParts[requestPathParts.length - 1], request.getRequestURI().split("/deleteSelectedIssues")[0]);
            } else if ("getRepositories".equals(requestType)) {
                this.handleGetRepositories(response);
            } else if ("getProjects".equals(requestType)) {
                this.handleGetProjects(response);
            } else if ("getProjectRepositories".equals(requestType)) {
                this.handleGetProjectRepositories(response, requestBody);
            } else {
                response.setStatus(400);
            }
        } else {
            response.setStatus(401);
        }
    }

    private void handleGetRepositories(HttpServletResponse response) throws IOException {
        List<ExtendedRepository> extendedRepositories = RepositoryServiceManager.getIntegratedRepositories();
        List repositories = extendedRepositories.stream().map(ExtendedRepository::getRepository).collect(Collectors.toList());
        String jsonToSend = new Gson().toJson(repositories);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(jsonToSend);
        response.getWriter().flush();
        response.getWriter().close();
    }

    private void handleGetProjects(HttpServletResponse response) throws IOException {
        List<ExtendedProject> extendedProjects = ProjectServiceManager.getIntegratedProjects();
        List projects = extendedProjects.stream().map(ExtendedProject::getProject).collect(Collectors.toList());
        String jsonToSend = new Gson().toJson(projects);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(jsonToSend);
        response.getWriter().flush();
        response.getWriter().close();
    }

    private void handleGetProjectRepositories(HttpServletResponse response, String requestBody) throws IOException {
        JSONObject jsonBody = new JSONObject(requestBody);
        if (!jsonBody.has("projectKey")) {
            response.setStatus(400);
            return;
        }
        String projectKey = jsonBody.getString("projectKey");
        ExtendedProject project = ProjectServiceManager.getProjectByKey(projectKey);
        ArrayList repositories = new ArrayList();
        if (project.getIntegratedProject() != null) {
            List<ExtendedRepository> extendedRepositories = RepositoryServiceManager.getIntegratedProjectRepositories(project.getId());
            extendedRepositories.forEach(r -> repositories.add(ConvertUtils.convertToRepositoryDto(r.getRepository(), BranchServiceManager.getDefaultBranch(r.getRepository()), this.authenticationContext.getCurrentUser())));
        }
        String jsonToSend = new Gson().toJson(repositories);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(jsonToSend);
        response.getWriter().flush();
        response.getWriter().close();
    }

    private void renderIssuesPage(HttpServletResponse response, Repository repository) throws ServletException, IOException {
        List<RepoVulInfo> repoVulInfoValues = this.repoVulInfoService.findByRepoNameAndOrderedBySeverity(RepositoryServiceManager.getFullRepoName(repository));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REPOSITORY, repository);
        map.put("repoVulInfoValues", repoVulInfoValues);
        this.render(response, "plugin.whitesource.repository", map);
    }

    private String getRequestType(String requestBody, String[] requestPathParts) throws IOException {
        String requestType = "";
        if (StringUtils.isBlank(requestBody)) {
            if (requestPathParts.length > 2) {
                requestType = requestPathParts[3];
            }
        } else {
            JSONObject jsonBody = new JSONObject(requestBody);
            if (jsonBody.has(REQUEST_TYPE)) {
                requestType = jsonBody.getString(REQUEST_TYPE);
            }
        }
        return requestType;
    }

    private void handleCreateIssue(HttpServletResponse response, Repository repository, String fullRepoName, String requestBody) throws IOException {
        RepoVulnerabilityObject repoVulnerabilityObject = this.convertRequestBodyToRepoVulnerability(fullRepoName, requestBody);
        RepoVulInfo repoVulInfo = this.repoVulInfoService.add(repoVulnerabilityObject);
        if (repoVulInfo != null) {
            response.setStatus(200);
            response.getWriter().write(this.createResponseToBolt(repoVulnerabilityObject.getTitle(), repoVulnerabilityObject.getHtmlVulnerability(), repoVulInfo.getID()).toString());
            response.getWriter().flush();
            response.getWriter().close();
            this.sendIssueWebhook(repository, repoVulInfo);
        } else {
            response.setStatus(400);
        }
    }

    private boolean sendIssueWebhook(Repository repository, RepoVulInfo repoVulInfo) {
        JsonObject jsonBody = this.buildIssueCreatedPayload(repository, repoVulInfo);
        WebhookSender webhookSender = new WebhookSender(this.pluginConfigurationManager.getWebhookUrl());
        boolean sendSucceeded = webhookSender.sendWebhookUpdate(jsonBody.toString(), REPO_ISSUE_WEBHOOK);
        return sendSucceeded;
    }

    private void handleGetIssues(HttpServletResponse response, String fullRepoName, Repository repository) throws IOException {
        RepoVulInfo[] repoVulInfos;
        JsonArray arrayOfIssues = new JsonArray();
        if (RepositoryHookServiceManager.isWhiteSourceHookEnabled(repository) && (repoVulInfos = this.repoVulInfoService.findByRepoName(fullRepoName)) != null) {
            for (RepoVulInfo repoVulInfo : repoVulInfos) {
                arrayOfIssues.add(this.createResponseToBolt(repoVulInfo.getCve(), repoVulInfo.getVulnerability(), repoVulInfo.getID()));
            }
        }
        String jsonToSend = new Gson().toJson(arrayOfIssues);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(jsonToSend);
        response.getWriter().flush();
        response.getWriter().close();
    }

    private void handleGetIssueByRepoNameAndId(HttpServletResponse response, String fullRepoName, String requestBody) throws IOException {
        String issueId = null;
        JSONObject jsonBody = new JSONObject(requestBody);
        if (!jsonBody.has("issueId")) {
            response.setStatus(404);
            return;
        }
        issueId = jsonBody.getString("issueId");
        RepoVulInfo repoVulInfo = this.repoVulInfoService.findByRepoNameAndId(fullRepoName, Integer.valueOf(issueId));
        if (repoVulInfo == null) {
            response.setStatus(404);
        } else {
            JsonObject jsonObject = this.createResponseToBolt(repoVulInfo.getCve(), repoVulInfo.getVulnerability(), repoVulInfo.getID());
            String jsonToSend = new Gson().toJson(jsonObject);
            response.setStatus(200);
            response.getWriter().write(jsonToSend);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().flush();
            response.getWriter().close();
        }
    }

    private void handleDeleteIssues(HttpServletResponse response, String fullRepoName) {
        this.repoVulInfoService.deleteIssues(fullRepoName);
        response.setStatus(200);
    }

    private void handleUpdateIssueToEnableRemediate(Repository repository, HttpServletResponse response, String issueId, String redirectUrl) throws ServletException, IOException {
        RepoVulInfo repoVulInfo = this.repoVulInfoService.findByRepoNameAndId("", Integer.valueOf(issueId));
        if (repoVulInfo != null) {
            String body = repoVulInfo.getVulnerability();
            body = body.replace("<!-- REMEDIATE-OPEN-PR-CHECKBOX-IND -->", "\n<hr>\n\u26d1\ufe0f Automatic Remediation will be attempted for this issue.");
            body = body.replace("\"isOpenPROnVulnerability\":false", "\"isOpenPROnVulnerability\":true");
            repoVulInfo.setVulnerability(body);
            repoVulInfo.save();
            this.sendIssueWebhook(repository, repoVulInfo);
        }
        response.sendRedirect(redirectUrl);
    }

    private void handleDeleteSelectedIssues(Repository repository, HttpServletResponse response, String issueId, String redirectUrl) throws ServletException, IOException {
        this.repoVulInfoService.deleteIssue(Integer.valueOf(issueId));
        response.sendRedirect(redirectUrl);
    }

    private JsonObject createResponseToBolt(String title, String body, int id) {
        JsonObject result = new JsonObject();
        result.addProperty("id", id);
        result.addProperty("title", title);
        result.addProperty("body", body);
        return result;
    }

    private RepoVulnerabilityObject convertRequestBodyToRepoVulnerability(String fullRepoName, String requestBody) {
        RepoVulnerabilityObject result = new RepoVulnerabilityObject();
        result.setFullRepoName(fullRepoName);
        JSONObject jsonBody = new JSONObject(requestBody);
        if (jsonBody.has("title")) {
            result.setTitle(jsonBody.getString("title"));
        }
        if (jsonBody.has("cve")) {
            result.setCve(jsonBody.getString("cve"));
        }
        if (jsonBody.has("severity")) {
            result.setSeverity(SeverityType.valueOf(jsonBody.getString("severity").toUpperCase()));
        }
        if (jsonBody.has("body")) {
            result.setHtmlVulnerability(jsonBody.getString("body"));
        }
        return result;
    }

    private JsonObject buildIssueCreatedPayload(Repository repository, RepoVulInfo repoVulInfo) {
        Gson gson = new Gson();
        JsonObject jsonObject = this.createResponseToBolt(repoVulInfo.getCve(), repoVulInfo.getVulnerability(), repoVulInfo.getID());
        JsonObject result = new JsonObject();
        result.addProperty(EVENT_KEY, REPO_ISSUE_WEBHOOK);
        result.add(ACTOR, gson.toJsonTree(ConvertUtils.convertToActorDto(this.authenticationContext.getCurrentUser())));
        result.add(REPOSITORY, gson.toJsonTree(ConvertUtils.convertToRepositoryDto(repository, BranchServiceManager.getDefaultBranch(repository), this.authenticationContext.getCurrentUser())));
        result.add(ISSUE, jsonObject);
        return result;
    }
}

