/*
 * Decompiled with CFR 0.152.
 */
package activeObject;

import activeObject.IntegratedProject;
import activeObject.IntegratedProjectService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named
public class IntegratedProjectServiceImpl
implements IntegratedProjectService {
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public IntegratedProjectServiceImpl(ActiveObjects activeObjects) {
        if (activeObjects == null) {
            throw new NullPointerException();
        }
        this.activeObjects = activeObjects;
    }

    @Override
    public IntegratedProject add(Integer projectId, Boolean allRepositoriesIncluded) {
        IntegratedProject result = null;
        IntegratedProject project = this.get(projectId);
        if (project == null) {
            result = (IntegratedProject)this.activeObjects.create(IntegratedProject.class, new DBParam[0]);
            result.setProjectId(projectId);
            result.setAllRepositoriesIncluded(allRepositoriesIncluded);
            result.save();
        }
        return result;
    }

    @Override
    public IntegratedProject updateAllReposIncluded(Integer projectId, Boolean allRepositoriesIncluded) {
        IntegratedProject result = null;
        IntegratedProject project = this.get(projectId);
        if (project != null) {
            result = project;
            result.setAllRepositoriesIncluded(allRepositoriesIncluded);
            result.save();
        }
        return result;
    }

    @Override
    public IntegratedProject get(Integer projectId) {
        IntegratedProject result = null;
        IntegratedProject[] integratedProjects = (IntegratedProject[])this.activeObjects.find(IntegratedProject.class, Query.select().where("PROJECT_ID = ?", new Object[]{projectId}));
        if (integratedProjects != null && integratedProjects.length > 0) {
            result = integratedProjects[0];
        }
        return result;
    }

    @Override
    public Map<Integer, IntegratedProject> getAll() {
        IntegratedProject[] integratedProjectsArray = (IntegratedProject[])this.activeObjects.find(IntegratedProject.class);
        HashMap<Integer, IntegratedProject> integratedProjectsMap = new HashMap<Integer, IntegratedProject>();
        if (integratedProjectsArray != null) {
            for (IntegratedProject integratedProject : integratedProjectsArray) {
                integratedProjectsMap.put(integratedProject.getProjectId(), integratedProject);
            }
        }
        return integratedProjectsMap;
    }

    @Override
    public IntegratedProject delete(Integer projectId) {
        IntegratedProject project = this.get(projectId);
        if (project != null) {
            this.activeObjects.delete(new RawEntity[]{project});
        }
        return project;
    }
}

